/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.launching.exe;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org2.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org2.eclipse.php.internal.debug.core.preferences.PHPexes;
import org2.eclipse.php.internal.debug.core.sourcelookup.containers.LocalFileStorage;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;

public class PHPExeLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            PHPExeLaunchShortcut.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getPHPExeLaunchConfigType());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file == null) {
            File systemFile;
            IPath path = null;
            if (input instanceof IStorageEditorInput) {
                IStorageEditorInput editorInput = (IStorageEditorInput)input;
                try {
                    LocalFileStorage fileStorage = (LocalFileStorage)editorInput.getStorage();
                    path = fileStorage.getFullPath();
                }
                catch (CoreException e) {
                    PHPDebugEPLPlugin.logError(e);
                }
            } else if (input instanceof IPathEditorInput) {
                path = ((IPathEditorInput)input).getPath();
            } else if (input instanceof NonExistingFileEditorInput) {
                try {
                    if (editor instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editor;
                        TextFileDocumentProvider documentProvider = (TextFileDocumentProvider)textEditor.getDocumentProvider();
                        IDocument document = documentProvider.getDocument((Object)input);
                        documentProvider.saveDocument(null, (Object)input, document, true);
                        document.replace(0, 0, "");
                    }
                }
                catch (Exception e) {
                    PHPDebugEPLPlugin.logError(e);
                }
                path = ((NonExistingFileEditorInput)input).getPath(null);
            }
            if (path != null && (systemFile = new File(path.toOSString())).exists()) {
                PHPExeLaunchShortcut.searchAndLaunch(new Object[]{systemFile}, mode, this.getPHPExeLaunchConfigType());
            }
        } else {
            PHPExeLaunchShortcut.searchAndLaunch(new Object[]{file}, mode, this.getPHPExeLaunchConfigType());
        }
    }

    protected ILaunchConfigurationType getPHPExeLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("com.aptana.php.debug.core.launching.PHPExeLaunchConfigurationType");
    }

    public static void searchAndLaunch(Object[] search, String mode, ILaunchConfigurationType configType) {
        int entries = search == null ? 0 : search.length;
        int i = 0;
        while (i < entries) {
            block11: {
                try {
                    String phpExeName;
                    String phpPathString = null;
                    String phpFileLocation = null;
                    IProject project = null;
                    Object obj = search[i];
                    if (obj instanceof IFile) {
                        IFile file = (IFile)obj;
                        project = file.getProject();
                        IContentType contentType = Platform.getContentTypeManager().getContentType("com.aptana.contenttype.phtml.php");
                        if (contentType.isAssociatedWith(file.getName())) {
                            phpPathString = new File(file.getFullPath().toOSString()).exists() ? file.getFullPath().toOSString() : file.getFullPath().toString();
                            IPath location = file.getLocation();
                            phpFileLocation = location != null ? location.toOSString() : file.getFullPath().toString();
                        }
                    } else if (obj instanceof File) {
                        File systemFile = (File)obj;
                        phpFileLocation = phpPathString = systemFile.getAbsolutePath();
                    }
                    if (phpPathString == null) {
                        throw new CoreException((IStatus)new Status(4, "com.aptana.php.debug.epl", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                    }
                    PHPexeItem defaultEXE = PHPExeLaunchShortcut.getDefaultPHPExe(project);
                    if (defaultEXE == null) {
                        defaultEXE = PHPExeLaunchShortcut.getWorkspaceDefaultExe();
                    }
                    String string = phpExeName = defaultEXE != null ? defaultEXE.getExecutable().getAbsolutePath().toString() : null;
                    if (phpExeName == null) {
                        MessageDialog.openError((Shell)PHPDebugEPLPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_noexe_msg_title, (String)PHPDebugUIMessages.launch_noexe_msg_text);
                        PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugEPLPlugin.getActiveWorkbenchShell(), (String)"org2.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage", null, null).open();
                        return;
                    }
                    ILaunchConfiguration config = PHPExeLaunchShortcut.findLaunchConfiguration(project, phpPathString, phpFileLocation, defaultEXE, mode, configType);
                    if (config != null) {
                        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
                        break block11;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.aptana.php.debug.epl", 0, PHPDebugUIMessages.launch_failure_no_config, null));
                }
                catch (CoreException ce) {
                    final IStatus stat = ce.getStatus();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugEPLPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_exec_msg_text, (IStatus)stat);
                        }
                    });
                }
            }
            ++i;
        }
    }

    private static PHPexeItem getWorkspaceDefaultExe() {
        String phpDebuggerId = PHPDebugEPLPlugin.getCurrentDebuggerId();
        return PHPexes.getInstance().getDefaultItem(phpDebuggerId);
    }

    private static PHPexeItem getDefaultPHPExe(IProject project) {
        IEclipsePreferences node;
        IScopeContext[] preferenceScopes;
        String phpDebuggerId = PHPDebugEPLPlugin.getCurrentDebuggerId();
        PHPexeItem defaultItem = PHPexes.getInstance().getDefaultItem(phpDebuggerId);
        if (defaultItem == null) {
            return null;
        }
        String phpExe = defaultItem.getName();
        if (project != null && (preferenceScopes = PHPExeLaunchShortcut.createPreferenceScopes(project))[0] instanceof ProjectScope && (node = preferenceScopes[0].getNode(PHPProjectPreferences.getPreferenceNodeQualifier())) != null) {
            phpDebuggerId = node.get("com.aptana.php.debug.php_debugger_id", phpDebuggerId);
            phpExe = node.get("com.aptana.php.debug.epldefaultPHP", phpExe);
        }
        return PHPexes.getInstance().getItem(phpDebuggerId, phpExe);
    }

    private static IScopeContext[] createPreferenceScopes(IProject project) {
        if (project != null) {
            return new IScopeContext[]{new ProjectScope(project), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    protected static ILaunchConfiguration findLaunchConfiguration(IProject phpProject, String phpPathString, String phpFileFullLocation, PHPexeItem defaultEXE, String mode, ILaunchConfigurationType configType) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int numConfigs = configs == null ? 0 : configs.length;
            int i = 0;
            while (i < numConfigs) {
                boolean usFile = configs[i].getAttribute("ATTR_USE_SPECIFIC_FILE", false);
                if (usFile) {
                    String fileName = configs[i].getAttribute("ATTR_FILE", null);
                    String exeName = configs[i].getAttribute("ATTR_LOCATION", null);
                    String iniPath = configs[i].getAttribute("ATTR_INI_LOCATION", null);
                    PHPexeItem item = PHPexes.getInstance().getItemForFile(exeName, iniPath);
                    if (phpPathString.equals(fileName) && defaultEXE.equals(item)) {
                        config = configs[i];
                        break;
                    }
                }
                ++i;
            }
            if (config == null) {
                config = PHPExeLaunchShortcut.createConfiguration(phpProject, phpPathString, phpFileFullLocation, defaultEXE, configType);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return config;
    }

    protected static ILaunchConfiguration createConfiguration(IProject phpProject, String phpPathString, String phpFileFullLocation, PHPexeItem defaultEXE, ILaunchConfigurationType configType) throws CoreException {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, PHPExeLaunchShortcut.getNewConfigurationName(phpPathString));
        wc.setAttribute("com.aptana.php.debug.php_debugger_id", defaultEXE.getDebuggerID());
        AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(defaultEXE.getDebuggerID());
        wc.setAttribute("com.aptana.php.debug.configurationDelegateClass", debuggerConfiguration.getScriptLaunchDelegateClass());
        wc.setAttribute("ATTR_FILE", phpPathString);
        wc.setAttribute("ATTR_USE_SPECIFIC_FILE", true);
        wc.setAttribute("ATTR_FILE_FULL_PATH", phpFileFullLocation);
        wc.setAttribute("ATTR_LOCATION", defaultEXE.getExecutable().getAbsolutePath().toString());
        String iniPath = defaultEXE.getINILocation() != null ? defaultEXE.getINILocation().toString() : null;
        wc.setAttribute("ATTR_INI_LOCATION", iniPath);
        wc.setAttribute("org2.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugEPLPlugin.getDebugInfoOption());
        wc.setAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine(phpProject));
        config = wc.doSave();
        return config;
    }

    protected static String getNewConfigurationName(String fileName) {
        String configurationName = "New_configuration";
        try {
            IPath path = Path.fromOSString((String)fileName);
            String fileExtention = path.getFileExtension();
            String lastSegment = path.lastSegment();
            if (lastSegment != null) {
                if (fileExtention != null) {
                    lastSegment = lastSegment.replaceFirst("." + fileExtention, "");
                }
                configurationName = lastSegment;
            }
        }
        catch (Exception e) {
            PHPDebugEPLPlugin.logError("Could not generate configuration name for " + fileName + ".\nThe default name will be used.", e);
        }
        return DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configurationName);
    }
}

